#######
# @author Tom Gregory, 2019
# For use by MSIS Tech Bootcamp / ISF Project
#
# You may need to install the Flask module for this code to work
# `pip3 install flask` may do it

from flask import Flask, redirect, render_template, request, url_for
app = Flask(__name__)
app.env = 'development'

from sushi_model import SushiModel # This is a model class definition file I made


@app.route('/')               # A "route" is the path the user sees in the browser
@app.route('/menu')           # A controller may have more than one route
def menu():
    return render_template(
        'menu.html',          # This file needs to be in the 'templates' folder
        all_sushi = SushiModel.fetch_all()  # Permits the template to use the `all_sushi` variable
    )

@app.route('/edit/<int:id>')  # To use a variable in a route, declare it here
def edit_sushi(id):           # ... and use it here in the controller definition
    return render_template(
        'edit.html',          # This file needs to be in the 'templates' folder
        action = 'edit',
        sushi = SushiModel.fetch_by_id(id)
    )

@app.route('/create')
def create_sushi():
    return render_template(
        'edit.html',          # Re-using a template
        action = 'create',
        sushi = SushiModel()  # An empty SushiModel
    )

# This route/function processes HTML forms
# Forms should use the POST method. This page has no View. The controller
# processes the form, then redirects to a regular page.
@app.route('/handleEditForm/<int:id>', methods=['POST'])
def update_sushi(id):
    s = SushiModel({
        'id': id,
        'name': request.form['name'],  # these key names are from the HTML form elements
        'price': request.form['price']
    })
    
    if id == 0:
        s.create()
    else:
        s.update()
    
    return redirect(url_for('menu'))

@app.route('/handleDeleteForm/<int:id>', methods=['POST'])
def delete_sushi(id):
    s = SushiModel.fetch_by_id(id)
    s.delete()
    return redirect(url_for('menu'))

if __name__ == '__main__':
    app.run()
